package gov.va.med.mhv.usermgmt.service.impl;

import gov.va.med.mhv.core.util.TimestampUtils;
import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.MCCIMT000200UV01Acknowledgement;
import gov.va.med.mhv.mvi.xsd.MCCIMT000200UV01AcknowledgementDetail;
import gov.va.med.mhv.mvi.xsd.MCCIMT000300UV01Acknowledgement;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02MFMIMT700711UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAIN201310UV02MFMIMT700711UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAMT201304UV02Patient;
import gov.va.med.mhv.mvi.xsd.PRPAMT201310UV02OtherIDs;
import gov.va.med.mhv.mvi.xsd.PRPAMT201310UV02Patient;
import gov.va.med.mhv.mvi.xsd.MCCIIN000002UV01Document.MCCIIN000002UV01;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document.PRPAIN201305UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02Document.PRPAIN201306UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201310UV02Document.PRPAIN201310UV02;
import gov.va.med.mhv.service.MHVAbstractService;
import gov.va.med.mhv.usermgmt.bizobj.FacilityInfoBO;
import gov.va.med.mhv.usermgmt.bizobj.UserProfileBO;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.AuthenticationStatus;
import gov.va.med.mhv.usermgmt.enumeration.PatientCorrelationStatus;
import gov.va.med.mhv.usermgmt.service.InPersonAuthenticationServiceResponse;
import gov.va.med.mhv.usermgmt.service.MviIntegrationService;
import gov.va.med.mhv.usermgmt.service.PatientServiceResponse;
import gov.va.med.mhv.usermgmt.service.ServiceFactory;
import gov.va.med.mhv.usermgmt.service.UserProfileServiceResponse;
import gov.va.med.mhv.usermgmt.service.handler.MviInvocationUtilHandler;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;
import gov.va.med.mhv.usermgmt.transfer.Facility;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;
import gov.va.med.mhv.usermgmt.transfer.MviAuthComm;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.PatientRegistryChange;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;
import gov.va.med.mhv.usermgmt.util.Auditor;
import gov.va.med.mhv.usermgmt.util.InPersonAuthenticationStatusUtils;
import gov.va.med.mhv.usermgmt.util.PatientCorrelationStatusUtils;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIAuthenticationRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVICorrelationRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIGetCorrespondingRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIPatientSearchRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVISearchByEdipiRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVISearchReqUSAA;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIUnCorrelationRequest;
import gov.va.med.mhv.usermgmt.util.mvi.MviConstants;
import gov.va.med.mhv.usermgmt.util.mvi.MviRequestTypeEnum;
import gov.va.med.mhv.usermgmt.util.mvi.MviResponseTypeEnum;
import gov.va.med.mhv.usermgmt.util.mvi.MviUtil;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.service.BooleanServiceResponse;
import org.tigris.atlas.service.StringServiceResponse;

/**
 * Service implementation class for the MviIntegration service
 * @see gov.va.med.mhv.usermgmt.service.MviIntegrationService
 */
public class MviIntegrationServiceImpl extends MHVAbstractService implements MviIntegrationService{

    private static final String MVI_AUTH_ACTION = "MVI AUTH";
    private static final String MVI_UNAUTH_ACTION = "MVI UNAUTH";
    private static final String SUCCESS_RESULT = "SUCCESS";
    private static final String COMMUNICATION_ERROR_RESULT = "COMMUNICATION ERROR";
    private static final String AE_ERROR_RESULT = "AE ERROR";
    private static final String AL_ERROR_RESULT = "AL ERROR";

	private static final Log LOG = LogFactory.getLog(MviIntegrationServiceImpl.class);

	//public static final String wsdlURL="http://serverserver1.abc.domain.ext:0000/psim_webservice/IdMWebService?WSDL";
	public String wsdlURL = null;
	//public static final String wsdlURL="http://server.commserv.healtheman.domain:0000/psim_webservice/PSIMWebService?WSDL";
	//public static final String namespace ="http://wwww.abc.domain.ext";
	//public static final String serviceName="VAIdM";
	//public static final String portName="VAIdMPort";

	


	/**
	 * Execute the SearchPersonInMVI service
	 * @throws Exception
	 * @see gov.va.med.mhv.usermgmt.service.MviIntegrationService#SearchPersonInMVI()
	 */
//	public PatientServiceResponse searchPersonInMVI(String firstName, String lastName, String middleName, String gender, Date birthDate, String ssn, Boolean isPatient, Boolean isVeteran) {
	public PatientServiceResponse searchPersonInMVI(UserProfile userProfile, Boolean atRegistration) {
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		PatientServiceResponse response = new PatientServiceResponse();
		Patient patient = TransferObjectFactory.createPatient();
		boolean flag = false;
		PRPAIN201306UV02 searchRes = null;
		// Service business logic here
		long startTime = System.currentTimeMillis();
		Object searchReqXML = CreateMVIPatientSearchRequest.createPatientSearchXMLRequest(userProfile);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXML);
		if (responseXMLString.equalsIgnoreCase("ERROR")) {
			addInfo(response, "mvi.parse.response.issue",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
			response.setPatient(null);
			return response;
		}
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String)searchReqXML, responseXMLString);
		long endTime = System.currentTimeMillis();
		if(LOG.isDebugEnabled())
			LOG.debug("Time taken to execute Search Call: " +(endTime-startTime));
		if(searchObj != null)
			searchRes = (PRPAIN201306UV02)searchObj;
		if(searchRes ==null) {
			LOG.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			addInfo(response, "mvi.parse.response.issue",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
			response.setPatient(null);
			return response;
		}
		String ICNFromResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		PRPAIN201305UV02 searchXmlObj = null;
		if(queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			try {
				PRPAIN201305UV02Document searchXmlObjRoot = PRPAIN201305UV02Document.Factory.parse((String) searchReqXML);
				searchXmlObj = searchXmlObjRoot.getPRPAIN201305UV02();
			}catch (Exception ex) {
				ex.printStackTrace();
				return response;
			}
			ICNFromResponse=getICNfromSearchResult(searchXmlObj, searchRes);
			if(ICNFromResponse == null) {
				addInfo(response, "mvi.parse.response.issue",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
				patient = null;
			}
			else {
				//JAZZ Task#20972 - Check SSN from 1306 MVI response message and display error if SSN is different from MHV Patient
				String SSNFromMviResponse = null;
				SSNFromMviResponse=getSSNfromSearchResult(searchXmlObj, searchRes);
				String numberOnlySsn = StringUtils.replace(userProfile.getSsn(), "-", "");
				if(SSNFromMviResponse==null || !(numberOnlySsn.equals(SSNFromMviResponse))) {
					if(atRegistration) {
						addInfo(response, "mvi.patient.not.found",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
						response.setPatient(null);
						return response;
					} else {
						addInfo(response, "mvi.update.advanced.failure.response",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
						response.setPatient(null);
						return response;
					}
				}

				PatientServiceResponse patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientByIcn(ICNFromResponse);
				if ( patResponse.getPatient() != null && patResponse.getPatient().getPatientPK() != null) {
					//Patient Exists with the SAME ICN.. GET OUT!!
					addError(response, "mvi.advanced.account.exist",new String[]{MviConstants.FORGOTUSERID_URL, MviConstants.FORGOTPASSWORD_URL, MviConstants.CONTACTMHV_URL} );
					response.setPatient(null);
					return response;
				}
				// Got ICN and now adding happy message and facilities if he is a patient
				patient.setIcn(ICNFromResponse);
				/*
				long startTimeForCorresCall = System.currentTimeMillis();
				Object correspondingReqXML = CreateMVIGetCorrespondingRequest.createMVIGetCorrespondingRequest(ICNFromResponse);
				//MviInvocationUtilHandler mviInvokeHandler2 = new MviInvocationUtilHandler();
				String corresResponseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), correspondingReqXML);
				PRPAIN201310UV02 searchCorresRes = (PRPAIN201310UV02) messageParser.mVIMessageParser(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), corresResponseXMLString);
				long endTimeForCorresCalls = System.currentTimeMillis();
				if(LOG.isDebugEnabled())
					LOG.debug("Time taken to execute Corres Call: " +(endTimeForCorresCalls-startTimeForCorresCall));
				*/
				//	Merge Starts Here
				if (searchRes.getControlActProcess().getSubjectArray() != null ) {
					PRPAIN201306UV02MFMIMT700711UV01Subject1[] subjectSearchArray = searchRes.getControlActProcess().getSubjectArray();
					if(subjectSearchArray[0].getRegistrationEvent() != null) {
						PRPAMT201310UV02Patient searchResultPatient = subjectSearchArray[0].getRegistrationEvent().getSubject1().getPatient();
						II[] searchPatientIdArray = searchResultPatient.getIdArray();
						patient = addFacilitiesForPatient(searchPatientIdArray, patient, userProfile, response);
						/*	for (int i=0; i< searchPatientIdArray.length; i++) {
							II patientId = searchPatientIdArray[i];
							String searchIdExtension = patientId.getExtension();
							if (searchIdExtension.contains("PI")) {
								String[] idExtn = searchIdExtension.split("\\^");
								String stationNumber = idExtn[2];
								if(!StringUtils.isBlank(stationNumber)) {
									Facility facility = TransferObjectFactory.createFacility();
									if(LOG.isDebugEnabled())
										LOG.debug("FACILITY ID: " +idExtn[2]);
									facility.setName(stationNumber);
									patient.addFacility(facility);
								}
							}
						}*/
					}
				}
				
				if(!response.getMessages().hasErrorMessages()) {
					addInfo(response, "mvi.advanced.success.response",new String[]{MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW});
				} else {
					response.setPatient(null);
					return response;
				}
				// Merge Ends Here
				/*	if(searchCorresRes != null && searchCorresRes.getControlActProcess().getSubjectArray() != null) {
					PRPAIN201310UV02MFMIMT700711UV01Subject1[] subjectArray = searchCorresRes.getControlActProcess().getSubjectArray();
					if(subjectArray[0].getRegistrationEvent() != null) {
						PRPAMT201304UV02Patient corresPatient = subjectArray[0].getRegistrationEvent().getSubject1().getPatient();
						II[] patientIdArray = corresPatient.getIdArray();
						for(int i=0; i<patientIdArray.length; i++) {
							II patientId = patientIdArray[i];
							String idExtension = patientId.getExtension();
							if (idExtension.contains("NI")) {
								if(LOG.isDebugEnabled())
									LOG.debug("Ignoring this ID coz this is NI: " +idExtension);
							}
							else {
								String[] idExtn = idExtension.split("\\^");
								String stationNumber = idExtn[2];
								Facility facility = TransferObjectFactory.createFacility();
								if(LOG.isDebugEnabled())
									LOG.debug("FACILITY ID: " +idExtn[2]);
								facility.setName(stationNumber);
								patient.addFacility(facility);
							}
						}
					}
				}*/
			}
		}
		else {
			patient = null;
			if(queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())){
				addInfo(response, "mvi.parse.response.issue",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
				if(LOG.isErrorEnabled())
					LOG.error("Max Results Exceeded in MVI: "+queryResponseCode.getCode());
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())){
					//addInfo(response, "mvi.parse.response.issue");
				if(atRegistration) {
					addInfo(response, "mvi.parse.response.ae.issue.reg",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW} );
				} else {
					addInfo(response, "mvi.parse.response.ae.issue",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW} );
				}
				if(LOG.isErrorEnabled())
					LOG.error("Application Error in MVI: "+queryResponseCode.getCode());
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())){
					addInfo(response, "mvi.patient.not.found",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
				if(LOG.isErrorEnabled())
					LOG.error("User not found in MVI: "+queryResponseCode.getCode());
			}
			response.setPatient(null);
			return response;

		}
		//gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
		response.setPatient(patient);
		return response;
	}

	private String getICNfromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {
		
		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			II idArray[] = patient.getIdArray();
			for (int i=0; i< idArray.length; i++) {
				II patientId = idArray[i];
				String searchIdExtension = patientId.getExtension();
				if (searchIdExtension.contains("NI")) {
					String[] idExtn = searchIdExtension.split("\\^");
					String source = idExtn[2];
					String issuer = idExtn[3];
					if(source.equals("200M") && issuer.equals("USVHA")) {
						String patientICN = idExtn[0];
						return patientICN;
					}
				}
			}
		}
		else {
			LOG.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

	private String getSSNfromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {
		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			PRPAMT201310UV02OtherIDs[] otherIds = patient.getPatientPerson().getAsOtherIDsArray();
			for (int i=0; i< otherIds.length; i++) {
				PRPAMT201310UV02OtherIDs otherId = otherIds[i];
				//JAZZ Defect # 29216 - MVI correlation issue - User with Alias SSN will not be matched or correlated- Fix:Made sure that the SSN is compared with equals instead of contains 
				if(otherId.getClassCode().equals("SSN")) {
					II idArray[] = otherId.getIdArray();
					for (int j=0; j< idArray.length; i++) {
						II id = idArray[j];
						return id.getExtension();
					}
				}
			}
		}
		else {
			LOG.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

	// Outdated - 
	private String getICNfromSearchResult(PRPAIN201306UV02 searchRes) {
		PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
		PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
		PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
		II idArray[] = patient.getIdArray();
		for (int i=0; i< idArray.length; i++) {
			II patientId = idArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains("NI")) {
				String[] idExtn = searchIdExtension.split("\\^");
				String source = idExtn[2];
				String issuer = idExtn[3];
				if(source.equals("200M") && issuer.equals("USVHA")) {
					String patientICN = idExtn[0];
					return patientICN;
				}
			}
		}
		return null;
	}

	public StringServiceResponse getEdipiFromMVI(gov.va.med.mhv.usermgmt.transfer.Patient patient) {
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		StringServiceResponse response = new StringServiceResponse();
		Object correspondingReqXML = CreateMVIGetCorrespondingRequest.createMVIGetCorrespondingRequest(patient.getIcn());
		String corresResponseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), correspondingReqXML);
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		PRPAIN201310UV02 searchCorresRes = (PRPAIN201310UV02) messageParser.mVIMessageParser(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(),(String)correspondingReqXML, corresResponseXMLString);
		String responseStr = MviUtil.getEdipiSearchResult(searchCorresRes);
		response.setString(responseStr);
		return response;
	}

	/*
	 * Update Treatment facilities for existing users that are in the following categories
	 */
	public PatientServiceResponse updateTreatmentFacilitiesForExistingPatients(gov.va.med.mhv.usermgmt.transfer.Patient patient){
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		PatientServiceResponse ptResponse = new PatientServiceResponse();
		Object correspondingReqXML = CreateMVIGetCorrespondingRequest.createMVIGetCorrespondingRequest(patient.getIcn());

		String corresResponseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), correspondingReqXML);
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		PRPAIN201310UV02 searchCorresRes = (PRPAIN201310UV02) messageParser.mVIMessageParser(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(),(String)correspondingReqXML, corresResponseXMLString);

		if(searchCorresRes != null && searchCorresRes.getControlActProcess().getSubjectArray() != null) {
			PRPAIN201310UV02MFMIMT700711UV01Subject1[] subjectArray = searchCorresRes.getControlActProcess().getSubjectArray();
			if(subjectArray[0].getRegistrationEvent() != null) {
				PRPAMT201304UV02Patient corresPatient = subjectArray[0].getRegistrationEvent().getSubject1().getPatient();
				II[] patientIdArray = corresPatient.getIdArray();
				processFacilityChanges(receivedFacilitiesFromMvi(patientIdArray), patient, patient.getUserProfile(), ptResponse);
			}
			if (LOG.isDebugEnabled()) {
				LOG.debug("DEBUG MESSAGE: updateTreatmentFacilitiesForExistingPatients:searchCorresRes for patient: " + patient.getUserProfile().getUserName());
			}
			addInfo(ptResponse, "mvi.treatment.facilities.rxrefill.success",new String[]{patient.getUserProfile().getUserName()} );
		}else{
			if (LOG.isErrorEnabled()) {
				LOG.error("ERROR: updateTreatmentFacilitiesForExistingPatients:searchCorresRes for patient: " + patient.getUserProfile().getUserName());
			}
			addError(ptResponse, "mvi.treatment.facilities.rxrefill.error",new String[]{patient.getUserProfile().getUserName()} );
		}
		ptResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
		return ptResponse;
	}

	/*
	 * MHV_CodeCR1918 - US12.5 MVI Compliance Implementation - Implementation of the service call for MVI Uncorrelate from
	 * IPA page. The reason there are two separate methods for IPA and Helpdesk is that for IPA, we don't want to display error messages
	 * while we do in Helpdesk.
	 */
	public PatientServiceResponse deletePersonFromCorrelationForIPA(Patient patient, UserProfile userProfile, String adminUserName) {
		PatientServiceResponse response = new PatientServiceResponse();
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		MCCIIN000002UV01 searchCorrelRes = null;
		// Service business logic here
		if(patient == null || patient.getIcn() == null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
				if(patient != null)
					LOG.error("ICN is Empty: " +patient.getIcn());
			}
			return response;
		}
		
		Object correlationReqXML = CreateMVIUnCorrelationRequest.createUnCorrelationXMLRequest(userProfile, patient);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), correlationReqXML);
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(),(String)correlationReqXML, responseXMLString);
		
		if(searchObj ==null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("UNABLE TO PARSE THE UNCORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
			}
			//Admin Portal_CodeCR1816 - Make sure that the updated status/dates of correlation are displayed.
			response.setPatient(patient);
			addError(response, "mvi.ipa.correlation.communication.error",new String[]{} );
		}
		else {
			searchCorrelRes = (MCCIIN000002UV01)searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			//Array should have only 1 ACK
			acknowledgement = acknowledgementArray[0];
			
			String authenticator = ActivityActorTypeEnumeration.MHV_AUTHENTICATOR;
			if(adminUserName != null && adminUserName.equals("SYSTEM")) {
				authenticator = adminUserName;
			}
			
			if(acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[]  acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail =acknowledgementDetailArray[0];
				
				//JAZZ:17653 - during uncorrelation, change the correlation status to matched.
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.MVI_DATA_MATCH);
				//Defect 19541 - We don't need to set MPI Control to be false since we are in correlation status 7 MVI Match
//				userProfile.setIsMPIControlled(false);
//				UserProfileServiceResponse uResponse = 
//					gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(userProfile);

				Auditor.auditMviEvent(userProfile.getId(), authenticator,
					true, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				if (LOG.isErrorEnabled()) {
					LOG.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForIPA():Successful Uncorrelation For the ICN: "+patient.getIcn());
				}
			} else {
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.PENDING_UNCORRELATION);
				Auditor.auditMviEvent(userProfile.getId(), authenticator,
					false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				if (LOG.isErrorEnabled()) {
					LOG.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForIPA():Error In Uncorrelation For the ICN: "+patient.getIcn());
				}
			}
			patient.setCorrelatedDateTime(null);
			patient.setCorrelateRequestDateTime(null);
			patient.setCorrelatedBy(null);
			gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
			response.setPatient(patient);
		}

		return response;
	}
	
	/*
	 * MHV_CodeCR1919 - US12.4.x MVI Compliance Implementation - Implementation of the service call for MVI Uncorrelate from
	 * Helpdesk page. The reason there are two separate methods for IPA and Helpdesk is that for IPA, we don't want to display error messages
	 * while we do in Helpdesk.
	 */
	public PatientServiceResponse deletePersonFromCorrelationForHelpDesk(Patient patient, UserProfile userProfile, String adminUserName) {
		PatientServiceResponse response = new PatientServiceResponse();
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		MCCIIN000002UV01 searchCorrelRes = null;
		// Service business logic here
		if(patient == null || patient.getIcn() == null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
				if(patient != null)
					LOG.error("ICN is Empty: " +patient.getIcn());
			}
			return response;
		}
		
		Object correlationReqXML = CreateMVIUnCorrelationRequest.createUnCorrelationXMLRequest(userProfile, patient);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), correlationReqXML);
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), (String)correlationReqXML, responseXMLString);
		
		if(searchObj ==null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("UNABLE TO PARSE THE UNCORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
			}
			//Admin Portal_CodeCR1816 - Make sure that the updated status/dates of correlation are displayed.
			response.setPatient(patient);
			addError(response, "mvi.ipa.correlation.communication.error",new String[]{} );
		}
		else {
			searchCorrelRes = (MCCIIN000002UV01)searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			//Array should have only 1 ACK
			acknowledgement = acknowledgementArray[0];
			
			String authenticator = ActivityActorTypeEnumeration.HELP_DESK_ADMINISTRATOR;
			if(adminUserName != null && adminUserName.equals("SYSTEM")) {
				authenticator = adminUserName;
			}
			
			String fullName = getPatientFullName(patient);
			
			if(acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[]  acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail =acknowledgementDetailArray[0];

				//JAZZ:17620 - during uncorrelation, change the correlation status to uncorrelated and matched date to null.
				patient.setCorrelatedDateTime(null);
				userProfile.setIsMPIControlled(false);
				UserProfileServiceResponse uResponse = 
					gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(userProfile);

				userProfile = uResponse.getUserProfile();
				
				if(userProfile.getMessages().hasErrorMessages()) {
					addError(response, "mvi.ipa.uncorrelation.error",new String[]{fullName, "Error saving userProfile"} );
        			Iterator iterator = userProfile.getMessages().getErrorMessages().iterator();
        			while(iterator.hasNext()) {
        				StringBuffer str = new StringBuffer("deletePersonFromCorrelationForHelpDesk() failed for user profile id: "+userProfile.getId() + " ERROR:");
		        		Message message = (Message)iterator.next();
    					str.append(message.getKey());
    					if (message.getInserts().size() > 0) {
    						str.append("; inserts=[").append(message.getInserts()).
    						append("]");
    					}
		    			if (message.getProperties().size() > 0) {
		    				str.append("; properties=[").append(message.getProperties()).
		    					append("]");
		    			}
		    			if(LOG.isErrorEnabled()) {
		    				LOG.error(str);
		    			}
        			}	
					Auditor.auditMviEvent(userProfile.getId(), authenticator,
							false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
					if (LOG.isErrorEnabled()) {
						LOG.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForHelpDesk():Error In Uncorrelation For the ICN: "+patient.getIcn());
					}
					return response;
				}
				
				//JAZZ:17620 - during uncorrelation, change the correlation status to uncorrelated and matched date to null.
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.UNCORRELATED);
				patient.setMatchedDateTime(null);

				//CodeCR2022- Make sure that the save won't roll back.
				addInfo(response, "mvi.ipa.uncorrelation.success",new String[]{fullName} );
				Auditor.auditMviEvent(userProfile.getId(), authenticator,
					true, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				//JAZZ 18074 - Record Unmatched in AAL table.
				Auditor.auditMviEvent(userProfile.getId(), authenticator,
						true, ActivityActionTypeEnumeration.REMOVE_UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				if (LOG.isErrorEnabled()) {
					LOG.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForHelpDesk():Successful Uncorrelation For the ICN: "+patient.getIcn());
				}
			}
			else {
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.FAILED_UNCORRELATION);
				String error = acknowledgement.getTypeCode().getCode();
				error += ": "+acknowledgement.getAcknowledgementDetailArray()[0].getText();
				addInfo(response, "mvi.ipa.uncorrelation.error",new String[]{fullName, error} );
				Auditor.auditMviEvent(userProfile.getId(), authenticator,
					false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				if (LOG.isErrorEnabled()) {
					LOG.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForHelpDesk():Error In Uncorrelation For the ICN: "+patient.getIcn() + "Error:" + error);
				}
			}
			patient.setCorrelatedDateTime(null);
			patient.setCorrelateRequestDateTime(null);
			patient.setCorrelatedBy(null);
			gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
			response.setPatient(patient);
		}

		return response;
	}
	
	/*
	 * (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.MviIntegrationService#addPersonForCorrelationForIPA(gov.va.med.mhv.usermgmt.transfer.Patient, gov.va.med.mhv.usermgmt.transfer.UserProfile, java.lang.String)
	 */
	public PatientServiceResponse addPersonForCorrelationForIPA(Patient patient, UserProfile userProfile, String adminUserName) {
		PatientServiceResponse response = new PatientServiceResponse();
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		MCCIIN000002UV01 searchCorrelRes = null;
		// Service business logic here
		if(patient == null || patient.getIcn() == null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
				if(patient != null)
					LOG.error("ICN is Empty: " +patient.getIcn());
			}
			return response;
		}
		//patient.setCorrelationStatus(PatientCorrelationStatusUtils.PENDING_CORRELATION);
		patient.setCorrelateRequestDateTime(new Timestamp(System.currentTimeMillis()));
		//CR1514 - Save Correlation Performed By even when the correlation is not successful
		patient.setCorrelatedBy(adminUserName);
		PatientServiceResponse psr = gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);

		Object correlationReqXML = CreateMVICorrelationRequest.createCorrelationXMLRequest(userProfile,patient);
		//MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), correlationReqXML);
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), (String)correlationReqXML, responseXMLString);
		
		if(searchObj ==null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
			}
			//Admin Portal_CodeCR1816 - Make sure that the updated status/dates of correlation are displayed.
			response.setPatient(patient);
			addError(response, "mvi.ipa.correlation.communication.error",new String[]{} );
			//addError(response, "mvi.ipa.correlation.communication.error",new String[]{MviConstants.CONTACTMHV_URL_FROM_ADMIN_PORTAL} );
		}
		else {
			searchCorrelRes = (MCCIIN000002UV01)searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			//Array should have only 1 ACK
			//for (int i =0; i<=acknowledgementArray.length; i++) {
			acknowledgement = acknowledgementArray[0];
			//}
			if(acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[]  acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail =acknowledgementDetailArray[0];
				patient.setCorrelatedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.CORRELATED);
				gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);

				response.setPatient(patient);
				String fullName = getPatientFullName(patient);

				addInfo(response, "mvi.ipa.correlation.success",new String[]{fullName} );
				//Auditor.auditMviLoginEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,true, ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD);
				//MHV_CodeCR1856 - Made sure that MHV_AUTHENTICATOR displays instead of SYSTEM
				Auditor.auditMviEvent(userProfile.getId(),ActivityActorTypeEnumeration.MHV_AUTHENTICATOR,true, ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD,ActivityTypeEnumeration.ACCOUNT_UPGRADE);

		        InPersonAuthenticationServiceResponse ipaResponse = 
		        	ServiceFactory.createInPersonAuthenticationService().getIPAPatientById(
		        		patient.getId());
		        InPersonAuthentication ipa = ipaResponse.getInPersonAuthentication();
				if((ipa!=null) && (ipa.getStatus()!=null) && (ipa.getStatus()==AuthenticationStatus.getEnum(
						AuthenticationStatus.AUTHENTICATED))) {
			        ipa.setMviAuthenticationStatus("PENDING_AUTH");
			        AuthenticationStatus status = InPersonAuthenticationStatusUtils.AUTHENTICATED;
			        ipa.setStatus(status);
			        ServiceFactory.createEntityMaintenanceService().save(ipa);
			        patient.setPatientSynchronizations(null);
			        ServiceFactory.createEntityMaintenanceService().save(patient);
				}
			}
			else {
				//CR1514 - Make sure that Correlation Request Date, Correlation Requested by and Correlation Performed by
				//in the failed situations.
				response.setPatient(patient);
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.FAILED_CORRELATION);
				gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
				String fullName = getPatientFullName(patient);
				String error = acknowledgement.getTypeCode().getCode();
				error += ": "+acknowledgement.getAcknowledgementDetailArray()[0].getText();
				addError(response, "mvi.ipa.correlation.error",new String[]{fullName, error} );
			}

		}

		return response;

	}

	private PatientRegistryChange getChangeRecord(String forProperty, UserProfile userProfile) {
		if (LOG.isDebugEnabled()) {
			LOG.debug("found " + forProperty + " change for "
					+ userProfile.getUserName());
		}

		PatientRegistryChange changeRecord = TransferObjectFactory.createPatientRegistryChange();
		changeRecord.setRecordedOnDate(TimestampUtils.createCurrentTime());

		return changeRecord;
	}

	private String getPatientFullName(Patient patient) {
		StringBuffer fullName = new StringBuffer(patient.getUserProfile().getFirstName());

		//Admin Portal_CodeCR1789 - Make sure that there is a space in between First and Last Names.
		if(patient.getUserProfile().getMiddleName()!=null) {
			fullName.append(" " + patient.getUserProfile().getMiddleName());
		}
		fullName.append(" "	+ patient.getUserProfile().getLastName());
		return fullName.toString();
	}

	private String getUserFullName(UserProfile userProfile) {
		StringBuffer fullName = new StringBuffer(userProfile.getFirstName());

		//Admin Portal_CodeCR1789 - Make sure that there is a space in between First and Last Names.
		if(userProfile.getMiddleName()!=null) {
			fullName.append(" " + userProfile.getMiddleName());
		}
		fullName.append(" "	+ userProfile.getLastName());
		return fullName.toString();
	}

	//Note:	A-Active; D-Deprecated from a Duplicate; M-Deprecated from a Mismatch; U-Deprecated from an Unlink;	H-Deprecated from a Local Merge; P-Permanent

	public Patient addFacilitiesForPatient(II[]searchPatientIdArray, Patient patient, UserProfile userProfile, PatientServiceResponse response) {
		//boolean isReallyAPatient = false;
		List<String> stationNumberArray = new ArrayList<String>();
		for (int i=0; i< searchPatientIdArray.length; i++) {
			II patientId = searchPatientIdArray[i];
			String searchIdExtension = patientId.getExtension();
			if ( searchIdExtension != null && (searchIdExtension.contains("PI") || searchIdExtension.contains("NI") || 
				 searchIdExtension.contains("SS")) ) {
				String[] idExtn = searchIdExtension.split("\\^");
				if(idExtn.length>3) {
					String stationNumber = idExtn[2];
					String facilityStatus = idExtn[4];
					if(facilityStatus.equalsIgnoreCase("A") || facilityStatus.equalsIgnoreCase("4")) {
						if(!StringUtils.isBlank(stationNumber) ) {
							Facility facility = TransferObjectFactory.createFacility();
							stationNumberArray.add( stationNumber);
							if(LOG.isDebugEnabled())
								LOG.debug("FACILITY ID: " +idExtn[2]);
							facility.setName(stationNumber);
							patient.addFacility(facility);
						}
					}
				}
			}
		}
		//isReallyAPatient = checkTreatmentFacilitiesExist(stationNumberArray);
		if(MviUtil.checkTreatmentFacilitiesExist(stationNumberArray)){
			userProfile.setIsPatient(true);
		}
		else {
			userProfile.setIsPatient(false);
			userProfile.setIsVeteran(true);
		}
		UserProfileServiceResponse uResponse = 
			gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(userProfile);
		
		userProfile = uResponse.getUserProfile();
		
		if(userProfile.getMessages().hasErrorMessages()) {
			addError(response, "mvi.parse.response.issue", new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW} );
        	Iterator iterator = userProfile.getMessages().getErrorMessages().iterator();
        	while(iterator.hasNext()) {
        		StringBuffer str = new StringBuffer("addFacilitiesForPatient() failed for user profile id: "+userProfile.getId() + " ERROR:");
        		Message message = (Message)iterator.next();
    			str.append(message.getKey());
    			if (message.getInserts().size() > 0) {
    				str.append("; inserts=[").append(message.getInserts()).
    					append("]");
    			}
    			if (message.getProperties().size() > 0) {
    				str.append("; properties=[").append(message.getProperties()).
    					append("]");
    			}
				if (LOG.isErrorEnabled()) {
					LOG.error(str);
				}
        	}
			
		}

		return patient;
	}




	public static Object createStubRequest () {
		//Search Patient
		String reqXML="<?xml version=\"1.0\" encoding=\"UTF-8\"?>"+
		"<PRPA_IN201305UV02 xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:HL7-org:v3 ../../schema/HL7V3/NE2008/multicacheschemas/PRPA_IN201305UV02.xsd\" xmlns=\"urn:HL7-org:v3\" ITSVersion=\"XML_1.0\">"+
		"<id root=\"1.2.840.114350.1.13.0.1.7.1.1\" extension=\"MCID-12345\" />"+
		"<creationTime value=\"20070428150301\" />"+
		"<interactionId root=\"2.16.840.1.113883.1.6\" extension=\"PRPA_IN201305UV02\" />"+
		"<processingCode code=\"T\" />"+
		"<processingModeCode code=\"I\" />"+
		"<acceptAckCode code=\"AL\" />"+
		"<receiver typeCode=\"RCV\">"+
		"<device classCode=\"DEV\" determinerCode=\"INSTANCE\">"+
		"<id root=\"1.2.840.114350.1.13.999.234\" />"+
		"<telecom value=\"http://servicelocation/PDQuery\" />"+
		"</device>"+
		"</receiver>"+
		"<sender typeCode=\"SND\">"+
		"<device classCode=\"DEV\" determinerCode=\"INSTANCE\">"+
		"<id extension=\"200MH\" root=\"2.16.840.1.113883.4.349\"/>"+
		"</device>"+
		"</sender>"+
		"<controlActProcess classCode=\"CACT\" moodCode=\"EVN\">"+
		"<code code=\"PRPA_TE201305UV02\" codeSystem=\"2.16.840.1.113883.1.6\" />"+
		"<queryByParameter>"+
		"<queryId root=\"1.2.840.114350.1.13.28.1.18.5.999\" extension=\"18204\" />"+
		"<statusCode code=\"new\" />"+
		"<initialQuantity value=\"2\" />"+

		"<matchCriterionList>"+
		"<minimumDegreeMatch>"+
		"<value xsi:type=\"INT\" value=\"75\" />"+
		"<semanticsText>Degree of match requested</semanticsText>"+
		"</minimumDegreeMatch>"+
		"</matchCriterionList>"+
		"<parameterList>"+
		"<livingSubjectAdministrativeGender>"+
		"<value code=\"M\" />"+
		"<semanticsText>Gender</semanticsText>"+
		"</livingSubjectAdministrativeGender>"+
		"<livingSubjectBirthTime>"+
		"<value value=\"19780512\" />"+
		"<semanticsText>Date of Birth</semanticsText>"+
		"</livingSubjectBirthTime>"+
		"<livingSubjectId>"+
		"<value root=\"2.16.840.1.113883.4.1\" extension=\"111-11-1111\" />"+
		"<semanticsText>SSN</semanticsText>"+
		"</livingSubjectId>"+
		"<livingSubjectName>"+
		"<value use=\"L\">"+
		"<given>Daniel</given>"+
		"<given>Castle</given>"+
		"<prefix>PREFIX</prefix>"+
		"<suffix>SUFFIX</suffix>"+
		"<family>Lopez</family>"+
		"</value>"+
		"<semanticsText>Legal Name</semanticsText>"+
		"</livingSubjectName>"+
		"<patientAddress>"+
		"<value use=\"PHYS\">"+
		"<streetAddressLine>123 main st</streetAddressLine>"+
		"<streetAddressLine>Laurel</streetAddressLine>"+
		"<streetAddressLine>Street3</streetAddressLine>"+
		"<streetAddressLine>Street4</streetAddressLine>"+
		"<city>Miami</city>"+
		"<state>FL</state>"+
		"<postalCode>33123</postalCode>"+
		"<country>USA</country>"+
		"</value>"+
		"<semanticsText />"+
		"</patientAddress>"+
		"</parameterList>"+
		"</queryByParameter>"+
		"</controlActProcess>"+
		"</PRPA_IN201305UV02>";

		return reqXML;

	}

	//MHV_CodeCRTBD - Fixed the cronjob issue
	public BooleanServiceResponse mviUnauthenticateUncorrelateForBatch(Patient patient, UserProfile userProfile, String adminUserName) {
		BooleanServiceResponse response = new BooleanServiceResponse();
		String action = MVI_UNAUTH_ACTION;
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		//MHV_CodeCR1918 - US12.4.x MVI Compliance Implementation - Set the correlation status to Pending Uncorrelation
		//in case if it fails to call Uncorrelation due to error. Make sure that we check the current correlation status and 
		//it is correlated, pending correlation or pending uncorrelation
		//JAZZ: Task#19820 - Remove un-correlation call when users account is unauthenticated

		MCCIIN000002UV01 authenticateRes = null;
		if(patient == null || patient.getIcn() == null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Not Invoking Authentication Call because Patient object OR ICN is NULL: ");
				if(patient != null)
					LOG.error("ICN is Empty: " +patient.getIcn());
			}
			response.setBoolean(true);
			return response;
		}

		Object authenticationReqXML = CreateMVIAuthenticationRequest.createAuthenticationXMLRequest(userProfile, patient, false);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), authenticationReqXML);
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object authObj = null;

		try {
			authObj = messageParser.mVIMessageParser(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), (String)authenticationReqXML, responseXMLString);
		} catch(Throwable t) {
			t.printStackTrace();
			if (LOG.isErrorEnabled()) {
				LOG.error("error passing MviRequestTypeEnum.AUTHENTICATION_TYPE");
			}
		}

		if(authObj ==null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
			}

			addError(response, "mvi.advanced.account.exist",new String[]{MviConstants.FORGOTUSERID_URL, MviConstants.FORGOTPASSWORD_URL, MviConstants.CONTACTMHV_URL} );
			saveToCommunicationLog(userProfile.getId(), action, COMMUNICATION_ERROR_RESULT,
				"UNABLE TO PARSE THE AUTHENTICATION RESPONSE FROM MVI For the ICN: "+patient.getIcn(), true);
			response.setBoolean(true);
		}
		else {
			authenticateRes = (MCCIIN000002UV01)authObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = authenticateRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			acknowledgement = acknowledgementArray[0];
			if(acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[]  acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail =acknowledgementDetailArray[0];
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Success: MviIntegrationServiceImpl.mviAuthenticate():unauthenticating patient with icn:" + patient.getIcn());
                }
    			saveToCommunicationLog(userProfile.getId(), action, SUCCESS_RESULT, "", true);
    			if(deletePersonFromCorrelationForIPA(patient, userProfile, adminUserName).getMessages().hasErrorMessages()) {
    				response.setBoolean(false);
    			} else {
                    if (LOG.isDebugEnabled()) {
                    	LOG.debug("Success: MviIntegrationServiceImpl.deletePersonFromCorrelationForIPA():unauthenticating patient with icn:" + patient.getIcn());
                    }
    				response.setBoolean(true);
    			}
			}
			else {
				LOG.debug("Failure: MviIntegrationServiceImpl.mviAuthenticate():unauthenticating patient with icn:" + patient.getIcn()
        				+ " acknowledgement.getTypeCode().getCode():"+acknowledgement.getTypeCode().getCode());

				String detail = "";
				if(acknowledgement.getAcknowledgementDetailArray().length>0) {
					detail = acknowledgement.getAcknowledgementDetailArray()[0].getText();
				}
    			if(acknowledgement.getTypeCode().getCode().equals("AE")) {
    				saveToCommunicationLog(userProfile.getId(), action, AE_ERROR_RESULT, detail, true);

    			}else if(acknowledgement.getTypeCode().getCode().equals("AL"))
    				saveToCommunicationLog(userProfile.getId(), action, AL_ERROR_RESULT, detail, true);
				response.setBoolean(false);
			}
		}
		return response;
	}
	
	//MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - Adding new method call for MVI
	public BooleanServiceResponse mviAuthenticate(Patient patient, UserProfile userProfile, Boolean authenticate, Boolean batch) {
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		BooleanServiceResponse response = new BooleanServiceResponse();
		String action = MVI_UNAUTH_ACTION;
		if(authenticate) {
			action = MVI_AUTH_ACTION;
		} else {
			//MHV_CodeCR1918 - US12.4.x MVI Compliance Implementation - Set the correlation status to Pending Uncorrelation
			//in case if it fails to call Uncorrelation due to error. Make sure that we check the current correlation status and 
			//it is correlated, pending correlation or pending uncorrelation
            //JAZZ: Task#19820 - Remove un-correlation call when users account is unauthenticated
		}

		MCCIIN000002UV01 authenticateRes = null;
		if(patient == null || patient.getIcn() == null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Not Invoking Authentication Call because Patient object OR ICN is NULL: ");
				if(patient != null)
					LOG.error("ICN is Empty: " +patient.getIcn());
			}
			return response;
		}

		Object authenticationReqXML = CreateMVIAuthenticationRequest.createAuthenticationXMLRequest(userProfile, patient, authenticate);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), authenticationReqXML);
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object authObj = null;

		try {
			authObj = messageParser.mVIMessageParser(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), (String)authenticationReqXML, responseXMLString);
		} catch(Throwable t) {
			t.printStackTrace();
			if (LOG.isErrorEnabled()) {
				LOG.error("error passing MviRequestTypeEnum.AUTHENTICATION_TYPE");
			}
		}

		if(authObj ==null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
			}
			//TODO - distinguish between parese error and communicator error
			saveToCommunicationLog(userProfile.getId(), action, COMMUNICATION_ERROR_RESULT,
				"UNABLE TO PARSE THE AUTHENTICATION RESPONSE FROM MVI For the ICN: "+patient.getIcn(), batch);
			response.setBoolean(false);
		}
		else {
			authenticateRes = (MCCIIN000002UV01)authObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = authenticateRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			acknowledgement = acknowledgementArray[0];
			if(acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[]  acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail =acknowledgementDetailArray[0];
				response.setBoolean(true);
                if (LOG.isDebugEnabled()) {
                    if(authenticate)
                    	LOG.debug("Success: MviIntegrationServiceImpl.mviAuthenticate():authenticating patient with icn:" + patient.getIcn());
                    else
                    	LOG.debug("Success: MviIntegrationServiceImpl.mviAuthenticate():unauthenticating patient with icn:" + patient.getIcn());
                }
    			saveToCommunicationLog(userProfile.getId(), action, SUCCESS_RESULT, "", batch);
			}
			else {
                if(authenticate)
                	LOG.debug("Failure: MviIntegrationServiceImpl.mviAuthenticate():authenticating patient with icn:" + patient.getIcn()
                		+ " acknowledgement.getTypeCode().getCode():"+acknowledgement.getTypeCode().getCode());
                else
                	LOG.debug("Failure: MviIntegrationServiceImpl.mviAuthenticate():unauthenticating patient with icn:" + patient.getIcn()
        				+ " acknowledgement.getTypeCode().getCode():"+acknowledgement.getTypeCode().getCode());
				response.setBoolean(false);

				String detail = "";
				if(acknowledgement.getAcknowledgementDetailArray().length>0) {
					detail = acknowledgement.getAcknowledgementDetailArray()[0].getText();
				}
    			if(acknowledgement.getTypeCode().getCode().equals("AE")) {
    				saveToCommunicationLog(userProfile.getId(), action, AE_ERROR_RESULT, detail, batch);

    			}else if(acknowledgement.getTypeCode().getCode().equals("AL")) {
    				saveToCommunicationLog(userProfile.getId(), action, AL_ERROR_RESULT, detail, batch);
    			}
			}
		}
		return response;
	}

	private void saveToCommunicationLog(Long userProfileId, String action, String result, String detail, Boolean batch) {
		MviAuthComm mviAuthComm = TransferObjectFactory.createMviAuthComm();
		mviAuthComm.setUserProfileId(userProfileId);
		mviAuthComm.setAction(action);
		mviAuthComm.setResult(result);
		mviAuthComm.setDetail(detail);
		mviAuthComm.setCreatedTime(new Timestamp(System.currentTimeMillis()));
		if(batch) {
			mviAuthComm.setCronTime(new Timestamp(System.currentTimeMillis()));
		}
		gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(mviAuthComm);
	}

	private boolean duplicateCheck(UserProfile userProfile) {
		String firstName = StringUtils.lowerCase(userProfile.getFirstName());
		String lastName = StringUtils.lowerCase(userProfile.getLastName());

		if (UserProfileBO.getProfileByNameBirthDateSsnExcludeId(firstName, lastName,
				userProfile.getBirthDate(), userProfile.getSsn(), userProfile.getId()).size() > 1) {
			if (LOG.isDebugEnabled())
				LOG.debug("MviIntegrationServiceImpl.duplicateCheck(): Duplicate account found for the user: " + userProfile.getUserName());
		    return true;
        }
		return false;
	}

	/*
	 * Providing MATCH button in MHV Admin Portal IPA Search Detail page
	 * (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.MviIntegrationService#matchPersonInIPA(gov.va.med.mhv.usermgmt.transfer.UserProfile)
	 */
	public PatientServiceResponse matchPersonInIPA(UserProfile userProfile) {
		
		PatientServiceResponse response = new PatientServiceResponse();
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		if(userProfile == null || userProfile.getGender() == null || userProfile.getSsn() == null || userProfile.getBirthDate() == null || userProfile.getFirstName() == null || userProfile.getLastName() == null){
			addError(response, "mvi.ipa.match.keyattributes.null.error", new String[]{} );
			response.setPatient(null);
			return response;
		}

		if(duplicateCheck(userProfile)) {
			addError(response, "mvi.ipa.match.duplicate.error", new String[]{} );
			response.setPatient(null);
			return response;
		}

		MviProperties mviProp = MviProperties.getInstance();

		PRPAIN201306UV02 searchRes = null;

		Patient patient = null;
		PatientServiceResponse patResponse =
			gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientForUser(userProfile);
		if(patResponse.getPatient() != null) {
			patient = patResponse.getPatient(); 
		}
		
		Object searchReqXML = CreateMVIPatientSearchRequest.createPatientSearchXMLRequest(userProfile);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXML);
		
		if (responseXMLString!= null && responseXMLString.equalsIgnoreCase("ERROR")) {
			addError(response, "mvi.ipa.match.communication.error", new String[]{} );
			response.setPatient(patient);
			return response;
		}

		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String)searchReqXML, responseXMLString);
			
		MCCIMT000300UV01Acknowledgement acknowledgement = null;

		if(searchObj != null) {
			searchRes = (PRPAIN201306UV02)searchObj;
			MCCIMT000300UV01Acknowledgement[] acknowledgementArray = searchRes.getAcknowledgementArray();
			acknowledgement = acknowledgementArray[0];
		}

		if(searchRes == null) {
			LOG.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI in MHV Admin portal");
			addInfo(response, "mvi.ipa.match.communication.error",new String[]{MviConstants.ADVANCED_URL, MviConstants.CONTACTMHV_URL} );
			response.setPatient(patient);
			return response;
		}

		String ICNFromMviResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		String fullName = getUserFullName(userProfile);
		
		PRPAIN201305UV02 searchXmlObj = null;
		
		if(queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			try {
				PRPAIN201305UV02Document searchXmlObjRoot = PRPAIN201305UV02Document.Factory.parse((String) searchReqXML);
				searchXmlObj = searchXmlObjRoot.getPRPAIN201305UV02();
			}catch (Exception ex) {
				ex.printStackTrace();
				addError(response, "unknown.exception");
				response.setPatient(patient);
				return response;
			}
			
			//JAZZ Task#20972 - Check SSN from 1306 MVI response message and display error if SSN is different from MHV Patient
			String SSNFromMviResponse = null;
			SSNFromMviResponse=getSSNfromSearchResult(searchXmlObj, searchRes);
			String numberOnlySsn = StringUtils.replace(userProfile.getSsn(), "-", "");
			if(SSNFromMviResponse==null || !(numberOnlySsn.equals(SSNFromMviResponse))) {
				addError(response, "mvi.ipa.match.notfound.error",new String[]{fullName, ""} );
				Auditor.auditAccountUpgradeEvent(userProfile.getId(), false, ActivityActorTypeEnumeration.MHV_AUTHENTICATOR);
				response.setPatient(patient);
				return response;
			}
			
			ICNFromMviResponse=getICNfromSearchResult(searchXmlObj, searchRes);
			if(ICNFromMviResponse == null) {
				//addInfo(response, "mvi.parse.response.issue",new String[]{MviConstants.BASIC_URL, MviConstants.ADVANCED_URL, MviConstants.CONTACTMHV_URL} );
				String error = acknowledgement.getTypeCode().getCode();
				error += ": "+acknowledgement.getAcknowledgementDetailArray()[0].getText();
				addError(response, "mvi.ipa.match.error",new String[]{fullName, error} );
				response.setPatient(patient);
				return response;
			}
			else {
				boolean isPatientCreated = false;
				if(patient == null) {
					patient = TransferObjectFactory.createPatient();
					isPatientCreated = true;
					patient.setUserProfile(userProfile);
				}

				//CR 1980 - Override the existing ICN with the ICN from MVI if there is no other patient with the new ICN.
				if ((patient.getIcn()==null) || !patient.getIcn().equals(ICNFromMviResponse) ) {
					patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientByIcn(ICNFromMviResponse);
					if ( patResponse.getPatient() != null && patResponse.getPatient().getPatientPK() != null) {
						addError(response, "mvi.ipa.match.icn.duplicate.error",new String[]{fullName} );
						response.setPatient(patient);
						return response;
					} else {
						patient.setIcn(ICNFromMviResponse); 
						if(!isPatientCreated) {
							gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().updatePatientRegistryInformation(patient);
						}
					}
				}
				
				if (LOG.isDebugEnabled())
					LOG.debug("Existing Patients ICN Matched with MVI Response ICN OR Dealing with Existing Veteran");
				if (searchRes.getControlActProcess().getSubjectArray() != null ) {
					PRPAIN201306UV02MFMIMT700711UV01Subject1[] subjectSearchArray = searchRes.getControlActProcess().getSubjectArray();
					if(subjectSearchArray[0].getRegistrationEvent() != null) {
						PRPAMT201310UV02Patient searchResultPatient = subjectSearchArray[0].getRegistrationEvent().getSubject1().getPatient();
						II[] searchPatientIdArray = searchResultPatient.getIdArray();
						// Updating the facilities with the newer ones we received from MVI
						if(isPatientCreated) {
							patient = addFacilitiesForPatient(searchPatientIdArray, patient, userProfile, response);
						} else {
							processFacilityChanges(receivedFacilitiesFromMvi(searchPatientIdArray), patient, userProfile, response);
						}

						if(response.getMessages().hasErrorMessages()) {
							return response;
						}
					}
				}
				if(ICNFromMviResponse == null) {
					String error = acknowledgement.getTypeCode().getCode();
					error += ": "+acknowledgement.getAcknowledgementDetailArray()[0].getText();
					addError(response, "mvi.ipa.match.error",new String[]{fullName, error} );
					response.setPatient(patient);
					return response;
				}
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.MVI_DATA_MATCH);
				patient.setMatchedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
				PatientServiceResponse pResponse = 
					gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
				
				patient = pResponse.getPatient();
				patient.setUserProfile(userProfile);
				
				if(pResponse.getMessages().hasErrorMessages()) {
					addError(response, "mvi.ipa.match.error",new String[]{fullName, "Error saving patient"} );
					response.setPatient(patient);
					return response;
				}
				
				Set facilitiesList = new HashSet();
				facilitiesList = patient.getFacilitys();
				List<String> stationNumberArray = new ArrayList<String>();
				for (Object f: facilitiesList) {
					Facility facility = (Facility) f;
					stationNumberArray.add(facility.getName());
				}
				if(MviUtil.checkTreatmentFacilitiesExist(stationNumberArray))
					userProfile.setIsPatient(true);
				else {
					userProfile.setIsPatient(false);
					userProfile.setIsVeteran(true);
				}
				userProfile.setIsMPIControlled(true);
				
				UserProfileServiceResponse uResponse = 
					gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(userProfile);
				
				userProfile = uResponse.getUserProfile();
				
				if(userProfile.getMessages().hasErrorMessages()) {
					addError(response, "mvi.ipa.match.error.userprofile.save",new String[]{fullName, "Error saving User Profile"} );
        			Iterator iterator = userProfile.getMessages().getErrorMessages().iterator();
        			while(iterator.hasNext()) {
        				StringBuffer str = new StringBuffer("matchPersonInIPA() failed for user profile id: "+userProfile.getId() + " ERROR:");
		        		Message message = (Message)iterator.next();
    					str.append(message.getKey());
    					if (message.getInserts().size() > 0) {
    						str.append("; inserts=[").append(message.getInserts()).
    						append("]");
    					}
	    			if (message.getProperties().size() > 0) {
	    				str.append("; properties=[").append(message.getProperties()).
	    					append("]");
	    			}
	    			if(LOG.isErrorEnabled()) {
	    				LOG.error(str);
	    			}
	        	}
					

					response.setPatient(patient);
					return response;
				}

				response.setPatient(patient);
				// MVI Match success message
				addInfo(response, "mvi.ipa.match.success",new String[]{fullName} );
			}
		}
		else {
			if(queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())){
				String error = acknowledgement.getTypeCode().getCode();
				error += ": "+acknowledgement.getAcknowledgementDetailArray()[0].getText();
				addError(response, "mvi.ipa.match.queryerror.error",new String[]{fullName, error} );
				if(LOG.isErrorEnabled())
					LOG.error("Max Results Exceeded in MVI for the MATCH call made from IPA page: "+queryResponseCode.getCode() + " for user: " + fullName);
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())){
				String error = acknowledgement.getTypeCode().getCode();
				error += ": "+acknowledgement.getAcknowledgementDetailArray()[0].getText();
				addError(response, "mvi.ipa.match.applicationerror.error",new String[]{fullName, error} );
				if(LOG.isErrorEnabled())
					LOG.error("Application Error in MVI for the MATCH call made from IPA page: "+queryResponseCode.getCode() + " for user: " + fullName);
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())){
				String error = acknowledgement.getTypeCode().getCode();
				error += ": "+acknowledgement.getAcknowledgementDetailArray()[0].getText();
				addError(response, "mvi.ipa.match.notfound.error",new String[]{fullName} );
				if(LOG.isErrorEnabled())
					LOG.error("User not found in MVI for the MATCH call made from IPA page: "+queryResponseCode.getCode() + " for user: " + fullName);
			}
			response.setPatient(patient);
			return response;
		}

		return response;
	}

	public Map<String, Facility> receivedFacilitiesFromMvi(II[]searchPatientIdArray) {
		Map<String, Facility> receivedfacilityNames = new HashMap<String, Facility>();
		for (int i=0; i< searchPatientIdArray.length; i++) {
			II patientId = searchPatientIdArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains("PI") || searchIdExtension.contains("NI") ||
				searchIdExtension.contains("SS")) {
				String[] idExtn = searchIdExtension.split("\\^");
				if(idExtn.length>3) {
					String stationNumber = idExtn[2];
					String facilityStatus = idExtn[4];
					if(facilityStatus.equalsIgnoreCase("A") || facilityStatus.equalsIgnoreCase("4")) {
						if(!StringUtils.isBlank(stationNumber) ) {
							Facility facility = TransferObjectFactory.createFacility();
							facility.setName(stationNumber);
							receivedfacilityNames.put(stationNumber, facility);
						}
					}
				}
			}
		}
		return receivedfacilityNames;
	}

	private Map<String, Facility> collectStationNumbers(Patient patient) {
		assert patient != null : "Must provide a patient";
		Map<String, Facility> facilityNames =
			new HashMap<String, Facility>();
		for (Object f: patient.getFacilitys()) {
			Facility facility = (Facility) f;
			facilityNames.put(facility.getName(), facility);
		}
		return facilityNames;
	}

	private void processFacilityChanges(Map<String, Facility> receivedfacilityNames, Patient existingPatient, 
		UserProfile userProfile, PatientServiceResponse response) {
		Map<String, Facility> oldFacilities = collectStationNumbers(existingPatient);
		if (!CollectionUtils.isEqualCollection(receivedfacilityNames.keySet(),oldFacilities.keySet()))
		{
			PatientRegistryChange changeRec = getChangeRecord("Facilities", userProfile);
			changeRec.setOldFacilityCount(existingPatient.getFacilitys().size());
			existingPatient.addPatientRegistryChange(changeRec);
			Set<Facility> facilities = new HashSet<Facility>();
			for (String stationNumber: receivedfacilityNames.keySet()) {
				Facility facility = oldFacilities.get(stationNumber);
				if (facility == null) {
					if (LOG.isDebugEnabled()) {
						LOG.debug("Adding facility in evault from MVI " + stationNumber
								+ "'");
					}
					facility = receivedfacilityNames.get(stationNumber);
				} else {
					if (LOG.isDebugEnabled()) {
						LOG.debug("Keeping facility exists in evault'" + stationNumber +
								"' (" + facility.getId() + ")");
					}
				}
				
				List existingFacilities = FacilityInfoBO.queryByStationNumber(stationNumber);
				if(existingFacilities == null || existingFacilities.size() == 0){
					addError(response, "facility.not.found", new String[]{stationNumber});
				}
				else if(existingFacilities.size() > 1){
					addError(response, "facility.multiple.found", new String[]{stationNumber});
				}
				
				facilities.add(facility);
			}
			if (LOG.isDebugEnabled()) {
				for (String stationNumber: oldFacilities.keySet()) {
					Facility facility = receivedfacilityNames.get(stationNumber);
					if (facility == null) {
						LOG.debug("Removing facilities from evault with respect to the MVI response '" + stationNumber
								+ "'");
					}
				}
			}
			existingPatient.setFacilitys(facilities);
		}
	}
	public PatientServiceResponse searchPersonInMVIForDSLogon(String edipiValue) {
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		PatientServiceResponse response = new PatientServiceResponse();
		Patient patient = null;
		UserProfile userProfile = null;
		boolean flag = false;
		PRPAIN201310UV02 searchRes = null;
		// Service business logic here
		long startTime = System.currentTimeMillis();
		Object searchReqXML = CreateMVISearchByEdipiRequest.createMVISearchByEdipiRequest(edipiValue);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCHBY_EDIPI_TYPE.getReqType(), searchReqXML);
		if (responseXMLString.equalsIgnoreCase("ERROR")) {
			addInfo(response, "mvi.parse.response.issue",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
			//response.setPatient(null);
			response.setValue(MviConstants.MVI_COMM_ISSUE);
			return response;
		}
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCHBY_EDIPI_TYPE.getReqType(), (String)searchReqXML, responseXMLString);
		long endTime = System.currentTimeMillis();
		if(LOG.isDebugEnabled())
			LOG.debug("Time taken to execute Search Call for DSLogOn: " +(endTime-startTime));
		if(searchObj != null)
			searchRes = (PRPAIN201310UV02)searchObj;
		if(searchRes ==null) {
			LOG.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			return response;
		}
		//String ICNFromEdipiResponse = null;
		String DFNFromEdipiResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		if(queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			//ICNFromEdipiResponse = MviUtil.getICNfromEdipiSearchResult(searchRes);
			DFNFromEdipiResponse = MviUtil.getDFNfromEdipiSearchResultIf200MH(searchRes);
			if(DFNFromEdipiResponse == null) {
				// TODO: No DFN returned from MVI for Edipi Search
				if (LOG.isInfoEnabled())
					LOG.info("No DFN found in EDIPIResponse- means no 200MH exists");
				return response;
			} else if(DFNFromEdipiResponse.equalsIgnoreCase(MviConstants.MULTIPLE_IDS_ERROR)) {
				//JAZZ Story#39187 - US REQ#2 When MHV system checks to see if the user has one active advanced account known to MVI, in the event 
				//multiple accounts are returned from MVI, the system shall display a user-friendly error message in 
				//a yellow box at the top of We Cannot Connect Your Account page.  
				response.setValue(MviConstants.MULTIPLE_IDS_ERROR);
				return response;
			} else {
				UserProfileServiceResponse userProfileSerRes = gov.va.med.mhv.usermgmt.service.ServiceFactory.createUserProfileService().getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
				if (userProfileSerRes != null)
					userProfile = userProfileSerRes.getUserProfile();
				if (userProfile != null) {
					PatientServiceResponse patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientForUser(userProfile);
					if ( patResponse.getPatient() != null && patResponse.getPatient().getPatientPK() != null) {
						//DS LogOn Patient Exists with the SAME ICN in MHV
						response.setPatient(patResponse.getPatient());
						return response;
					}
				}
				else {
					// TODO: UserProfile NOT FOUND in MHV
					if (LOG.isErrorEnabled())
						LOG.error("200MH Found in EDIPIResponse but DFN Do NOT exist in MHV: " +DFNFromEdipiResponse);
					return response;
				}
			}
		}
		else {
			patient = null;
			if(queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())){
				if(LOG.isErrorEnabled())
					LOG.error("Max Results Exceeded in MVI 1310 EDIPI Call: "+queryResponseCode.getCode());
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())){
				if(LOG.isErrorEnabled())
					LOG.error("Application Error in MVI in 1310 EDIPI Call: "+queryResponseCode.getCode());
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())){
				if(LOG.isErrorEnabled())
					LOG.error("User not found in MVI in 1310 EDIPI Call: "+queryResponseCode.getCode());
			}
			response.setPatient(null);
			return response;

		}
		//gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
		response.setPatient(patient);
		return response;

	}
	
	public PatientServiceResponse searchPersonInMVIForUSAA(String fName, String mName, String lName, String DOB, String gender, String SSN) {
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		PatientServiceResponse response = new PatientServiceResponse();
		Patient patient = null;
		UserProfile userProfile = null;
		boolean flag = false;
		PRPAIN201306UV02 searchRes = null;
		// Service business logic here
		long startTime = System.currentTimeMillis();
		Object searchReqXML = CreateMVISearchReqUSAA.createPatientSearchXMLRequest(fName, mName, lName, DOB, gender, SSN);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXML);
		if (responseXMLString.equalsIgnoreCase("ERROR")) {
			addInfo(response, "mvi.parse.response.issue",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
			//response.setPatient(null);
			response.setValue(MviConstants.MVI_COMM_ISSUE);
			return response;
		}
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String)searchReqXML, responseXMLString);
		long endTime = System.currentTimeMillis();
		if(LOG.isDebugEnabled())
			LOG.debug("Time taken to execute Search Call for USAA: " +(endTime-startTime));
		if(searchObj != null)
			searchRes = (PRPAIN201306UV02)searchObj;
		if(searchRes ==null) {
			LOG.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			return response;
		}
		//String ICNFromEdipiResponse = null;
		String DFNFromEdipiResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		if(queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			//ICNFromEdipiResponse = MviUtil.getICNfromEdipiSearchResult(searchRes);
			DFNFromEdipiResponse = MviUtil.getDFNfromMVISearchResultIf200MH(searchRes);
			if(DFNFromEdipiResponse == null) {
				// TODO: No DFN returned from MVI for 1306 Search
				if (LOG.isErrorEnabled())
					LOG.error("No DFN found in USAASearch Response- means no 200MH exists");
				return response;
			} else if(DFNFromEdipiResponse.equalsIgnoreCase(MviConstants.MULTIPLE_IDS_ERROR)) {
				//JAZZ Story#39187 - US REQ#2 When MHV system checks to see if the user has one active advanced account known to MVI, in the event 
				//multiple accounts are returned from MVI, the system shall display a user-friendly error message in 
				//a yellow box at the top of We Cannot Connect Your Account page.  
				response.setValue(MviConstants.MULTIPLE_IDS_ERROR);
				return response;
			} else {
				UserProfileServiceResponse userProfileSerRes = gov.va.med.mhv.usermgmt.service.ServiceFactory.createUserProfileService().getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
				if (userProfileSerRes != null)
					userProfile = userProfileSerRes.getUserProfile();
				if (userProfile != null) {
					PatientServiceResponse patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientForUser(userProfile);
					if ( patResponse.getPatient() != null && patResponse.getPatient().getPatientPK() != null) {
						//DS LogOn Patient Exists with the SAME ICN in MHV
						response.setPatient(patResponse.getPatient());
						return response;
					}
				}
				else {
					// TODO: UserProfile NOT FOUND in MHV
					if (LOG.isErrorEnabled())
						LOG.error("200MH Found in USAASearch Response but DFN Do NOT exist in MHV: " +DFNFromEdipiResponse);
					return response;
				}
			}
		}
		else {
			patient = null;
			if(queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())){
				if(LOG.isErrorEnabled())
					LOG.error("Max Results Exceeded in MVI 1306 SEARCH Call: "+queryResponseCode.getCode());
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())){
				if(LOG.isErrorEnabled())
					LOG.error("Application Error in MVI in 1306 SEARCH Call: "+queryResponseCode.getCode());
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())){
				if(LOG.isErrorEnabled())
					LOG.error("User not found in MVI in 1306 SEARCH Call: "+queryResponseCode.getCode());
			}
			response.setPatient(null);
			return response;

		}
		//gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
		response.setPatient(patient);
		return response;

	}		

}